<?php
/**
 * OceanWP plugin update message
 *
 * @package OceanWP WordPress theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'OEW_Plugin_Update_Message' ) ) :

	class OEW_Plugin_Update_Message {

		/**
		 * Setup class.
		 *
		 * @since   2.3.0
		 */
		public function __construct() {

			add_action( 'in_plugin_update_message-ocean-elementor-widgets/ocean-elementor-widgets.php', array( $this, 'plugin_update_message' ), 10, 2 );
			add_action( 'admin_enqueue_scripts', array( $this, 'plugin_update_asset' ) );
		}

		/**
		 * Tested up to.
		 */
		public function plugin_tested_up_to_content() {

			$current_theme_version   = oew_get_theme_version();
			$requires_theme_at_least = $this->oew_get_plugin_header_data( 'ocean-elementor-widgets/ocean-elementor-widgets.php', 'RequiresOWP' );
			$requires_oe_at_least    = $this->oew_get_plugin_header_data( 'ocean-elementor-widgets/ocean-elementor-widgets.php', 'RequiresOE' );

			?>

			<hr class="owp-update-warning__separator">
			<div class="owp-update-warning">
				<div class="warning-info-icon">
					<span class="dashicons dashicons-info"></span>
				</div>
				<div>
					<div class="warning__title">
						<?php echo esc_html__( 'Compatibility Alert.', 'ocean-elementor-widgets' ); ?>
					</div>
					<div class="warning__message">
						<?php
						printf(
							esc_html__(
								'This plugin update requires compatibility with specific OceanWP theme versions and Ocean Extra. Please ensure your theme and Ocean Extra meets the following requirements before proceeding:',
								'ocean-elementor-widgets'
							),

						);
						?>
					</div>
					<div class="owp-required-products">
						<table class="owp-required-version-table">
							<tbody>
								<tr>
									<th><?php echo esc_html__( 'Items', 'ocean-elementor-widgets' ); ?></th>
									<th><?php echo esc_html__( 'Requires at Least', 'ocean-elementor-widgets' ); ?></th>
								</tr>
								<tr>
									<td><?php echo esc_html__( 'OceanWP', 'ocean-elementor-widgets' ); ?></td>
									<td><?php echo esc_attr( $requires_theme_at_least ); ?></td>
								</tr>
								<tr>
									<td><?php echo esc_html__( 'Ocean Extra', 'ocean-elementor-widgets' ); ?></td>
									<td><?php echo esc_attr( $requires_oe_at_least ); ?></td>
								</tr>

							</tbody>
						</table>
					</div>
				</div>
			</div>

			<?php
		}

		/**
		 * Enqueue scripts
		 *
		 * @since   2.2.9
		 */
		public function plugin_update_message( $plugin_data, $new_data ) {

			$current_theme_version = oew_get_theme_version();
			$current_oe_version    = '';

			if ( class_exists( 'Ocean_Extra' ) && defined( 'OE_VERSION' ) ) {
				$current_oe_version = OE_VERSION;
			}

			$requires_theme_at_least = $this->oew_get_plugin_header_data( 'ocean-elementor-widgets/ocean-elementor-widgets.php', 'RequiresOWP' );
			$requires_oe_at_least    = $this->oew_get_plugin_header_data( 'ocean-elementor-widgets/ocean-elementor-widgets.php', 'RequiresOE' );

			if ( ( ! empty( $current_theme_version ) && version_compare( $current_theme_version, $requires_theme_at_least, '<=' ) )
				|| ( ! empty( $current_oe_version ) && version_compare( $current_oe_version, $requires_oe_at_least, '<=' ) ) ) {
				if ( isset( $plugin_data['update'] ) && $plugin_data['update']  ) {
					$this->plugin_tested_up_to_content();
				}
			}

		}

		public function oew_get_plugin_header_data( $plugin_slug, $key_name ) {

			$plugin_file = WP_PLUGIN_DIR . '/' . $plugin_slug;

			$headers = array(
				'RequiresOWP' => 'OceanWP requires at least',
				'RequiresOE'  => 'Ocean Extra requires at least',
			);

			$plugin_data = get_file_data( $plugin_file, $headers );

			$get_data = isset( $plugin_data[$key_name] ) ? $plugin_data[$key_name] : false;

			return $get_data;
		}

		/**
		 * Script
		 */
		public function plugin_update_asset() {
			$screen = get_current_screen();

			if ( 'plugins' === $screen->id || 'plugins-network' === $screen->id ) {
				wp_enqueue_style(
					'oew-plugin-update',
					plugins_url( '/assets/css/pluginUpdateMessage.min.css', __DIR__ ),
					array(),
					false
				);
			}
		}

	}

endif;

new OEW_Plugin_Update_Message();
