// document.addEventListener('DOMContentLoaded', function() {

//     const urlParams = new URLSearchParams(window.location.search);

//     const verificationStatus = urlParams.get('email-verification');

//     if (verificationStatus) {
//         let message = '';
//         let type = 'success';

//         if ('success' === verificationStatus) {
//             message = oplEmailVerificationPopup.msgSuccess;
//             type = 'success';
//         } else if ('fail' === verificationStatus) {
//             message = oplEmailVerificationPopup.msgFailed;
//             type = 'error';
//         } else if ('link-expired' === verificationStatus) {
//             message = oplEmailVerificationPopup.msgExpired;
//             type = 'warning';
//         }

//         showVerificationPopup(message, type);
//     }

//     function showVerificationPopup(message, type) {
//         const overlay = document.createElement('div');
//         overlay.classList.add('opl-popup-email-verification-status-overlay');

//         const popupContainer = document.createElement('div');
//         popupContainer.classList.add('opl-popup-email-verification-status', type);

//         popupContainer.innerHTML = `
//             <div class="popup-content">
//                 <span class="close-popup">&times;</span>
//                 <p>${message}</p>
//             </div>
//         `;

//         document.body.appendChild(overlay);
//         document.body.appendChild(popupContainer);

//         document.documentElement.classList.add('opl-verification-popup');

//         popupContainer.querySelector('.close-popup').addEventListener('click', function() {
//             overlay.remove();
//             popupContainer.remove();
//             document.documentElement.classList.remove('opl-verification-popup');
//         });

//         // Timeout to remove the popup after 10 seconds
//         // setTimeout(function() {
//         //     popupContainer.remove();
//         // }, 10000);
//     }
// });


document.addEventListener('DOMContentLoaded', function () {
    const urlParams = new URLSearchParams(window.location.search);
    const verificationStatus = urlParams.get('email-verification');

    fetch(`${oplEmailVerificationPopup.ajax_url}?action=opl_check_email_verified`)
        .then(response => response.json())
        .then(data => {
            if (!data.success || !data.data.verification_done) {
                return;
            }

            const sessionStatus = data.data.verification_done;

            if (verificationStatus === 'success' && sessionStatus === 'success') {
                showVerificationPopup( oplEmailVerificationPopup.msgSuccess, 'success');
            } else if (verificationStatus === 'fail' && sessionStatus === 'fail') {
                showVerificationPopup(oplEmailVerificationPopup.msgFailed, 'error');
            } else if (verificationStatus === 'link-expired' && sessionStatus === 'expired') {
                showVerificationPopup(oplEmailVerificationPopup.msgExpired, 'warning');
            }
        })
        .catch(error => console.error('Error fetching email verification flag:', error));

    function showVerificationPopup(message, type) {
        const overlay = document.createElement('div');
        overlay.classList.add('opl-popup-email-verification-status-overlay');

        const popupContainer = document.createElement('div');
        popupContainer.classList.add('opl-popup-email-verification-status', type);

        popupContainer.innerHTML = `
            <div class="popup-content">
                <span class="close-popup">&times;</span>
                <p>${message}</p>
            </div>
        `;

        document.body.appendChild(overlay);
        document.body.appendChild(popupContainer);
        document.documentElement.classList.add('opl-verification-popup');

        function closePopup() {
            overlay.remove();
            popupContainer.remove();
            document.documentElement.classList.remove('opl-verification-popup');
        }

        popupContainer.querySelector('.close-popup').addEventListener('click', closePopup);

        setTimeout(closePopup, 10000);
    }
});
