<?php
/**
 * Active callback functions for the customizer
 */

function opl_popup_login_cac_has_custom_text() {
	if ( 'custom' == get_theme_mod( 'opl_popup_login_logged_in', 'logout' ) ) {
		return true;
	} else {
		return false;
	}
}

/**
 * Check whether the Privacy Policy is published (Settings -> Privacy).
 *
 * @return bool
 */
function opl_is_privacy_policy_set() {
	$privacy_policy_page_id = (int) get_option( 'wp_page_for_privacy_policy' );

    if ( empty( $privacy_policy_page_id ) ) {
        return false;
	}

	$privacy_policy_page = get_post( $privacy_policy_page_id );

	return $privacy_policy_page instanceof WP_Post
		&& $privacy_policy_page->post_status === 'publish';
}

function opl_cac_has_username_enable_limit() {
	if (true === get_theme_mod( 'opl_popup_username_enable_limit', false)) {
		return true;
	} else {
		return false;
	}
}

function opl_cac_has_mailchimp_subscribe() {
	if (true === get_theme_mod( 'opl_user_subscribe_mailchimp')) {
		return true;
	} else {
		return false;
	}
}

function opl_cac_has_user_email_verification() {
	if (true === get_theme_mod( 'opl_user_email_verification', false)) {
		return true;
	} else {
		return false;
	}
}

function opl_get_registered_user_roles() {
	global $wp_roles;
	$roles = apply_filters( 'editable_roles', ( isset( $wp_roles ) && is_object( $wp_roles ) ? $wp_roles->roles : array() ) );
	return wp_list_pluck( $roles, 'name' );
}

function opl_cac_has_recaptcha_enabled() {
	if ('google_recaptcha' === get_theme_mod( 'opl_popup_form_validation_method', opl_form_validation_default_value())) {
		return true;
	} else {
		return false;
	}
}

function opl_cac_has_recaptcha_on_other_forms() {
	if (true === get_theme_mod( 'opl_popup_recaptcha_enable_on_other_login_forms', false)
		&& true === opl_cac_has_recaptcha_enabled()) {
		return true;
	} else {
		return false;
	}
}

function opl_cac_has_turnstile_enabled() {
	if ('cloudflare_turnstile' === get_theme_mod( 'opl_popup_form_validation_method', opl_form_validation_default_value())) {
		return true;
	} else {
		return false;
	}
}

function opl_cac_has_turnstile_on_other_forms() {
	if (true === get_theme_mod( 'opl_popup_turnstile_enable_on_other_login_forms', false)
		&& true === opl_cac_has_turnstile_enabled()) {
		return true;
	} else {
		return false;
	}
}
