<?php
/**
 * OceanWP plugin update message
 *
 * @package OceanWP WordPress theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'OPL_Plugin_Update_Message' ) ) :

	class OPL_Plugin_Update_Message {

		/**
		 * Setup class.
		 *
		 * @since   2.3.0
		 */
		public function __construct() {

			add_action( 'in_plugin_update_message-ocean-popup-login/ocean-popup-login.php', array( $this, 'plugin_update_message' ), 10, 2 );
			add_action( 'admin_enqueue_scripts', array( $this, 'plugin_admin_notice_asset' ) );

			$current_theme_version = opl_get_theme_version();
			$current_oe_version    = '';

			if ( class_exists( 'Ocean_Extra' ) && defined( 'OE_VERSION' ) ) {
				$current_oe_version = OE_VERSION;
			}

			if ( ( ! empty( $current_theme_version ) && version_compare( $current_theme_version, '4.0.6', '<' ) )
				|| ( ! empty( $current_oe_version ) && version_compare( $current_oe_version, '2.4.5', '<' ) ) ) {
				add_action( 'admin_notices', array( $this, 'opl_admin_notice' ) );
				add_action( 'wp_ajax_opl_admin_notice_status', array( $this, 'opl_admin_notice_status' ) );
			}
		}

		/**
		 * Admin notice
		 */
		public function opl_admin_notice() {
			if (get_option('opl_admin_notice_status')) {
				return;
			}
			?>
			<div class="notice notice-warning is-dismissible" id="opl-admin-notice">

				<p>
					<?php
					printf(
						/* translators: %1$s Link open tag, %2$s: Link close tag. */
						esc_html__(
							'New features in Ocean Popup Login require %1$sOceanWP 4.0.6%2$s and Ocean %1$sExtra 2.4.5%2$s latest versions. Before proceeding, ensure your theme and the Ocean Extra plugin are up to date in order to avoid potential issues. %3$sLearn more%4$s.',
							'ocean-popup-login'
						),
						'<strong>',
						'</strong>',
						'<a href="https://docs.oceanwp.org/article/678-ocean-popup-login-changelog"  target="_blank">',
						'</a>'
					);
					?>
				</p>
			</div>
			<?php
		}

		/**
		 * Notice status update
		 */
		public function opl_admin_notice_status() {
			if (isset($_POST['nonce']) && wp_verify_nonce($_POST['nonce'], 'opl_admin_notice_nonce')) {

				update_option('opl_admin_notice_status', true);
				wp_send_json_success('Notice dismissed.');

			} else {
				wp_send_json_error('Invalid nonce.');
			}

			wp_die();
		}

		/**
		 * Message content
		 */
		public function plugin_update_content() {
			?>
			<hr class="owp-update-warning__separator">
			<div class="owp-update-warning">
				<div class="warning-info-icon">
					<span class="dashicons dashicons-info"></span>
				</div>
				<div>
					<div class="warning__title">
						<?php echo esc_html__( 'Backup recommended before plugin update.', 'ocean-popup-login' ); ?>
					</div>
					<div class="warning__message">
						<?php
						printf(
							/* translators: %1$s Link open tag, %2$s: Link close tag. */
							esc_html__( 'The latest update introduces significant improvements and changes to various plugin features.  For a smooth update process, it\'s crucial to %1$s backup your website beforehand  %2$s and test the update in a staging or test environment if available.', 'ocean-popup-login' ),
							'<a href="https://docs.oceanwp.org/article/875-how-to-safely-update-wordpress-website" target="_blank">',
							'</a>'
						);
						?>
					</div>
				</div>
			</div>

			<hr class="owp-update-warning__separator">
			<div class="owp-update-warning">
				<div class="warning-info-icon green">
					<span class="dashicons dashicons-yes-alt"></span>
				</div>
				<div>
					<div class="warning__title">
						<?php echo esc_html__( 'What\'s new?', 'ocean-popup-login' ); ?>
					</div>
					<div class="warning__message">
						<?php
						printf(
							/* translators: %1$s Link open tag, %2$s: Link close tag. */
							esc_html__( 'Revamped Customizer for enhanced experience! This update delivers a completely redesigned Customizer with a focus on improved user interface (UI), user experience (UX), and performance. Enjoy a faster and more intuitive way to personalize your website with a wider range of options at your fingertips. Learn %1$s how to properly update your websites and transition to OceanWP 4 %4$s, view %2$s OceanWP 4 New Customizer details %4$s or check out the %3$s OceanWP 4 Customizer documentation %4$s.', 'ocean-popup-login' ),
							'<a href="https://oceanwp.org/blog/oceanwp-4-release-announcement/" target="_blank">',
							'<a href="https://oceanwp.org/blog/customize-wordpress-new-core-update/" target="_blank">',
							'<a href="https://docs.oceanwp.org/category/894-oceanwp-customizer" target="_blank">',
							'</a>'
						);
						?>
					</div>
					<div class="owp-required-products">
						<table class="owp-required-version-table">
							<tbody>
								<tr>
									<th><?php echo esc_html__( 'Items', 'ocean-popup-login' ); ?></th>
									<th><?php echo esc_html__( 'Required Version', 'ocean-popup-login' ); ?></th>
								</tr>
								<tr>
									<td><?php echo esc_html__( 'OceanWP', 'ocean-popup-login' ); ?></td>
									<td><?php echo esc_html__( '4.0.0', 'ocean-popup-login' ); ?></td>
								</tr>
								<tr>
									<td><?php echo esc_html__( 'Ocean Extra', 'ocean-popup-login' ); ?></td>
									<td><?php echo esc_html__( '2.4.0', 'ocean-popup-login' ); ?></td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			<?php
		}

		/**
		 * Tested up to.
		 */
		public function plugin_tested_up_to_content() {

			$current_theme_version   = opl_get_theme_version();
			$requires_theme_at_least = $this->opl_get_plugin_header_data( 'ocean-popup-login/ocean-popup-login.php', 'RequiresOWP' );
			$requires_oe_at_least    = $this->opl_get_plugin_header_data( 'ocean-popup-login/ocean-popup-login.php', 'RequiresOE' );

			?>

			<hr class="owp-update-warning__separator">
			<div class="owp-update-warning">
				<div class="warning-info-icon">
					<span class="dashicons dashicons-info"></span>
				</div>
				<div>
					<div class="warning__title">
						<?php echo esc_html__( 'Compatibility Alert.', 'ocean-popup-login' ); ?>
					</div>
					<div class="warning__message">
						<?php
						printf(
							esc_html__(
								'This plugin update requires compatibility with specific OceanWP theme versions and Ocean Extra. Please ensure your theme and Ocean Extra meets the following requirements before proceeding:',
								'ocean-popup-login'
							),

						);
						?>
					</div>
					<div class="owp-required-products">
						<table class="owp-required-version-table">
							<tbody>
								<tr>
									<th><?php echo esc_html__( 'Items', 'ocean-popup-login' ); ?></th>
									<th><?php echo esc_html__( 'Requires at Least', 'ocean-popup-login' ); ?></th>
								</tr>
								<tr>
									<td><?php echo esc_html__( 'OceanWP', 'ocean-popup-login' ); ?></td>
									<td><?php echo esc_attr( $requires_theme_at_least ); ?></td>
								</tr>
								<tr>
									<td><?php echo esc_html__( 'Ocean Extra', 'ocean-popup-login' ); ?></td>
									<td><?php echo esc_attr( $requires_oe_at_least ); ?></td>
								</tr>

							</tbody>
						</table>
					</div>
				</div>
			</div>

			<?php
		}


		/**
		 * Enqueue scripts
		 *
		 * @since   2.2.9
		 */
		public function plugin_update_message( $plugin_data, $new_data ) {

			$current_theme_version = opl_get_theme_version();
			$current_oe_version    = '';

			if ( class_exists( 'Ocean_Extra' ) && defined( 'OE_VERSION' ) ) {
				$current_oe_version = OE_VERSION;
			}

			if ( ! empty( $current_theme_version ) && version_compare( $current_theme_version, '3.6.1', '<=' ) ) {
				if ( isset( $plugin_data['update'] ) && $plugin_data['update']  ) {
					$this->plugin_update_content();
				}
			}

			$requires_theme_at_least = $this->opl_get_plugin_header_data( 'ocean-popup-login/ocean-popup-login.php', 'RequiresOWP' );
			$requires_oe_at_least    = $this->opl_get_plugin_header_data( 'ocean-popup-login/ocean-popup-login.php', 'RequiresOE' );

			if ( ( ! empty( $current_theme_version ) && version_compare( $current_theme_version, $requires_theme_at_least, '<=' ) )
				|| ( ! empty( $current_oe_version ) && version_compare( $current_oe_version, $requires_oe_at_least, '<=' ) ) ) {
				if ( isset( $plugin_data['update'] ) && $plugin_data['update']  ) {
					$this->plugin_tested_up_to_content();
				}
			}

		}

		public function opl_get_plugin_header_data( $plugin_slug, $key_name ) {

			$plugin_file = WP_PLUGIN_DIR . '/' . $plugin_slug;

			$headers = array(
				'RequiresOWP' => 'OceanWP requires at least',
				'RequiresOE'  => 'Ocean Extra requires at least',
			);

			$plugin_data = get_file_data( $plugin_file, $headers );

			$get_data = isset( $plugin_data[$key_name] ) ? $plugin_data[$key_name] : false;

			return $get_data;
		}

		/**
		 * Script
		 */
		public function plugin_admin_notice_asset() {

			$screen = get_current_screen();

			if ( defined('OE_VERSION') && version_compare(OE_VERSION, '2.4.0', '<')) {

				if ( 'plugins' === $screen->id || 'plugins-network' === $screen->id ) {
					wp_enqueue_style(
						'opl-plugin-update',
						plugins_url( '/assets/css/pluginUpdateMessage.min.css', __DIR__ ),
						array(),
						false
					);
				}
			}

			$current_theme_version = opl_get_theme_version();

			if ( ( ! empty( $current_theme_version ) && version_compare( $current_theme_version, '4.0.6', '<' ) )
				|| ( defined('OE_VERSION') && version_compare(OE_VERSION, '2.4.5', '<') ) ) {
				wp_enqueue_script(
					'opl-admin-notice',
					plugins_url( '/assets/js/admin-notice.min.js', __DIR__ ),
					array('jquery'),
					null,
					true
				);

				wp_localize_script('opl-admin-notice', 'oplAdminNotice', array(
					'ajax_url' => admin_url('admin-ajax.php'),
					'nonce'    => wp_create_nonce('opl_admin_notice_nonce')
				));
			}
		}

	}

endif;

new OPL_Plugin_Update_Message();
