<?php
/**
 * Popup Login: Common functions
 *
 * @package OceanWP WordPress theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Recaptcha default value
 *
 * @since 2.2.1
 */
if ( ! function_exists( 'opl_recaptcha_default_value' ) ) {
    function opl_recaptcha_default_value() {

        $option_name = 'ocean-popup-login-start-version';

        if ( ! get_option( $option_name, false ) ) {
            return true;
        }

        $installed_version = get_option( $option_name );
        $opl_version = defined( 'OPL_PLUGIN_VERSION' ) ? OPL_PLUGIN_VERSION : '2.2.1';

        return version_compare( $installed_version, $opl_version, '<=' );
    }
}

/**
 * Default validation method.
 *
 * @since 2.2.1
 */
if ( ! function_exists( 'opl_form_validation_default_value' ) ) {
    function opl_form_validation_default_value() {

        $old_value = get_theme_mod( 'opl_popup_recaptcha_enable', false );
		$new_value = '';

        if ( $old_value ) {
            $new_value = 'google_recaptcha';
        }

        return $new_value;
    }
}

/**
 * Get theme version
 *
 * @since 2.2.1
 */
if ( ! function_exists( 'opl_get_theme_version' ) ) {

	function opl_get_theme_version() {

		$theme = wp_get_theme();

		$current_theme_version = '';

		if ('OceanWP' == $theme->name || 'oceanwp' == $theme->template) {

			if (get_template_directory() == get_stylesheet_directory()) {
				$current_theme_version = $theme->get('Version');
			} else {
				$parent = $theme->parent();
				if (!empty($parent)) {
					$current_theme_version = $parent->Version;
				}
			}
		}

		return $current_theme_version;
	}
}
