<?php
/**
 * Opening button shortcode
 */

if ( ! function_exists( 'osp_opening_btn_shortcode' ) ) {

	function osp_opening_btn_shortcode( $atts ) {

		// Extract attributes
		$attributes =  shortcode_atts( array(
			'icon' 		=> 'fa fa-bars',
			'btn' 		=> 'default',
			'text' 		=> '',
		), $atts );

		// Wrap class if text
		$class = ! empty( $attributes['text'] ) ? ' has-text' : '';

		ob_start();

		?>

		<a href="javascript:void(0);" class="side-panel-btn<?php echo esc_attr( $class ); ?>" role="button" aria-label="<?php echo __( 'Open Side Panel', 'ocean-side-panel' ) ?>">
			<?php if ( 'default' !== $attributes['btn'] ) : ?>
				<div class="side-panel-icon hamburger hamburger--<?php echo esc_attr( $attributes['btn'] ); ?>">
					<div class="hamburger-box">
						<div class="hamburger-inner"></div>
					</div>
				</div>
			<?php else : ?>
				<i class="side-panel-icon <?php echo esc_attr( $attributes['icon'] ); ?>" aria-hidden="true"></i>
			<?php endif; ?>

			<?php if ( ! empty( $attributes['text'] ) ) : ?>
				<span class="side-panel-text"><?php echo esc_html( $attributes['text'] ); ?></span>
			<?php endif; ?>
		</a>

		<?php

		return ob_get_clean();

	}

}
add_shortcode( 'osp_btn', 'osp_opening_btn_shortcode' );